
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="cherry_trees", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="sunflowers", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(6.23*x1 + 4.36*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(19*x1 + 9*x2 >= 88, name="water_need")
    model.addConstr(18*x1 + 30*x2 >= 59*144, name="planting_space")
    model.addConstr(8*x1 + 32*x2 >= 24, name="beauty_rating")
    model.addConstr(5*x1 + 27*x2 >= 98, name="growth_speed")
    model.addConstr(25*x1 + x2 >= 32, name="yield")
    model.addConstr(7*x1 - 3*x2 >= 0, name="cherry_sunflower_ratio")
    model.addConstr(19*x1 + 9*x2 <= 221, name="max_water_need")
    model.addConstr(18*x1 + 30*x2 <= 62*144, name="max_planting_space")
    model.addConstr(8*x1 + 32*x2 <= 39, name="max_beauty_rating")
    model.addConstr(5*x1 + 27*x2 <= 289, name="max_growth_speed")
    model.addConstr(25*x1 + x2 <= 161, name="max_yield")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cherry trees: {x1.varValue}")
        print(f"Sunflowers: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
