
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_optimization")

    # Create variables
    pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
    honeypots = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")


    # Set objective function
    m.setObjective(5.1 * pen_testers + 3.94 * honeypots, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(16 * pen_testers + 13 * honeypots >= 69, "computational_load_lower")
    m.addConstr(2 * pen_testers + 16 * honeypots >= 15, "data_confidentiality_lower")
    m.addConstr(-8 * pen_testers + 10 * honeypots >= 0, "constraint_3")
    m.addConstr(16 * pen_testers + 13 * honeypots <= 127, "computational_load_upper")
    m.addConstr(2 * pen_testers + 16 * honeypots <= 65, "data_confidentiality_upper")



    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value: %g' % m.objVal)
        print('Pen Testers: %g' % pen_testers.x)
        print('Honeypots: %g' % honeypots.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

