
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
x2 = m.addVar(vtype=GRB.INTEGER, name="honeypots")

# Set the objective function
m.setObjective(5.1*x1 + 3.94*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(16*x1 + 13*x2 >= 69, "computational_load_lower_bound")
m.addConstr(2*x1 + 16*x2 >= 15, "data_confidentiality_impact_lower_bound")
m.addConstr(-8*x1 + 10*x2 >= 0, "linear_constraint")
m.addConstr(16*x1 + 13*x2 <= 127, "computational_load_upper_bound")
m.addConstr(2*x1 + 16*x2 <= 65, "data_confidentiality_impact_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pen Testers: {x1.x}")
    print(f"Honeypots: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
