
import gurobipy as gp

# Create a new model
m = gp.Model("Optimization_Problem")

# Define the variables
pen_testers = m.addVar(name="pen_testers", vtype=gp.GRB.INTEGER)
honeypots = m.addVar(name="honeypots", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(5.1 * pen_testers + 3.94 * honeypots, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(pen_testers * 16 + honeypots * 13 >= 69, name="computational_load_min")
m.addConstr(pen_testers * 2 + honeypots * 16 >= 15, name="data_confidentiality_impact_min")
m.addConstr(-pen_testers * 8 + honeypots * 10 >= 0, name="pen_testers_honeypots_tradeoff")
m.addConstr(pen_testers * 16 + honeypots * 13 <= 127, name="computational_load_max")
m.addConstr(pen_testers * 2 + honeypots * 16 <= 65, name="data_confidentiality_impact_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Pen testers: {pen_testers.varValue}")
    print(f"Honeypots: {honeypots.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
