
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x = {}
item_names = ['fruit salads', 'rotisserie chickens', 'strawberries', 'cheeseburgers', 'bananas', 'slices of pizza', 'blueberry pies']
for i in range(len(item_names)):
    if item_names[i] in ['fruit salads', 'bananas', 'slices of pizza', 'blueberry pies']:
        x[i] = m.addVar(vtype=GRB.INTEGER, name=item_names[i])
    else:
        x[i] = m.addVar(vtype=GRB.CONTINUOUS, name=item_names[i])


# Set objective function
obj = 5*x[0]**2 + 6*x[0]*x[4] + 1*x[0]*x[5] + 1*x[0]*x[6] + 7*x[1]**2 + 8*x[1]*x[2] + 7*x[1]*x[3] + 3*x[1]*x[5] + 4*x[1]*x[6] + 8*x[2]**2 + 4*x[2]*x[3] + 4*x[2]*x[5] + 5*x[2]*x[6] + 2*x[3]**2 + 4*x[3]*x[4] + 4*x[3]*x[5] + 4*x[4]*x[6] + 2*x[5]*x[6] + 4*x[2] + 4*x[3] + 5*x[6]
m.setObjective(obj, GRB.MAXIMIZE)

# Add constraints
resource_data = {'r0': {'description': 'milligrams of iron', 'upper_bound': 660, 'x0': 10, 'x1': 31, 'x2': 27, 'x3': 30, 'x4': 1, 'x5': 10, 'x6': 12}, 'r1': {'description': 'grams of carbohydrates', 'upper_bound': 366, 'x0': 12, 'x1': 31, 'x2': 4, 'x3': 28, 'x4': 20, 'x5': 10, 'x6': 6}}

m.addConstr(10*x[0] + 31*x[1] + 27*x[2] + 30*x[3] + 1*x[4] + 10*x[5] + 12*x[6] <= resource_data['r0']['upper_bound'], "Iron Constraint")
m.addConstr(12*x[0] + 31*x[1] + 4*x[2] + 28*x[3] + 20*x[4] + 10*x[5] + 6*x[6] <= resource_data['r1']['upper_bound'], "Carbohydrate Constraint")
m.addConstr(12*x[0] + 20*x[4] <= 250)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

