
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # hours worked by Mary
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # hours worked by Laura


    # Set objective function
    model.setObjective(4*x0**2 + 7*x0, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2*x0 + 20*x1 >= 35, "c0")
    model.addConstr(4*x0 + 11*x1 >= 78, "c1")
    model.addConstr(5*x0 + 5*x1 >= 50, "c2")
    model.addConstr(7*x0**2 + 18*x1**2 >= 31, "c3")
    model.addConstr(11*x0 + 1*x1 >= 38, "c4")
    model.addConstr(2*x0 - 3*x1 >= 0, "c5")
    model.addConstr(2*x0**2 + 20*x1**2 <= 45, "c6")
    model.addConstr(4*x0 + 11*x1 <= 122, "c7")
    model.addConstr(5*x0 + 5*x1 <= 116, "c8")
    model.addConstr(7*x0**2 + 18*x1**2 <= 95, "c9")
    model.addConstr(11*x0 + 1*x1 <= 77, "c10")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
