
import gurobi as gp

# Define the model
model = gp.Model()

# Define the variables
x1 = model.addVar(name="hours_worked_by_Mary", lb=0)  # hours worked by Mary
x2 = model.addVar(name="hours_worked_by_Laura", lb=0)  # hours worked by Laura

# Define the objective function
model.setObjective(4 * x1**2 + 7 * x1, gp.GRB.MINIMIZE)

# Define the constraints
model.addConstr(2 * x1 + 20 * x2 >= 35, name="dollar_cost_per_hour")
model.addConstr(4 * x1 + 11 * x2 >= 78, name="computer_competence_rating")
model.addConstr(5 * x1 + 5 * x2 >= 50, name="productivity_rating")
model.addConstr(7 * x1**2 + 18 * x2**2 >= 31, name="paperwork_competence_rating")
model.addConstr(11 * x1 + x2 >= 38, name="work_quality_rating")
model.addConstr(2 * x1 - 3 * x2 >= 0, name="hourly_work_constraint")
model.addConstr(2**2 * x1**2 + 20**2 * x2**2 <= 45, name="dollar_cost_per_hour_squared")
model.addConstr(4 * x1 + 11 * x2 <= 122, name="computer_competence_rating_upper_bound")
model.addConstr(5 * x1 + 5 * x2 <= 116, name="productivity_rating_upper_bound")
model.addConstr(7 * x1**2 + 18 * x2**2 <= 95, name="paperwork_competence_rating_upper_bound")
model.addConstr(11 * x1 + x2 <= 77, name="work_quality_rating_upper_bound")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Mary: {x1.varValue}")
    print(f"Hours worked by Laura: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
