
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
protein = m.addVar(vtype=gp.GRB.INTEGER, name="protein")  # grams of protein (integer)
vitamin_d = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_d")  # milligrams of vitamin D

# Set objective function
m.setObjective(7 * protein + 3 * vitamin_d, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15 * protein + 14 * vitamin_d >= 33, "kidney_support_min")
m.addConstr(5 * protein + 25 * vitamin_d >= 78, "cardio_support_min")
m.addConstr(9 * protein - 6 * vitamin_d >= 0, "protein_vitamin_ratio")
m.addConstr(15 * protein + 14 * vitamin_d <= 75, "kidney_support_max")
m.addConstr(5 * protein + 25 * vitamin_d <= 189, "cardio_support_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('grams of protein:', protein.x)
    print('milligrams of vitamin D:', vitamin_d.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

