
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="grams_of_protein")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_D")

# Set objective function
m.setObjective(7*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(15*x1 + 14*x2 >= 33, name="kidney_support_index_min")
m.addConstr(5*x1 + 25*x2 >= 78, name="cardiovascular_support_index_min")
m.addConstr(9*x1 - 6*x2 >= 0, name="protein_vitamin_constraint")
m.addConstr(15*x1 + 14*x2 <= 75, name="kidney_support_index_max")
m.addConstr(5*x1 + 25*x2 <= 189, name="cardiovascular_support_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of Protein: {x1.x}")
    print(f"Milligrams of Vitamin D: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
