
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="grams_of_protein", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="milligrams_of_vitamin_D")

# Set the objective function
model.setObjective(7 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(15 * x1 + 14 * x2 >= 33, name="kidney_support_index_min")
model.addConstr(5 * x1 + 25 * x2 >= 78, name="cardiovascular_support_index_min")
model.addConstr(9 * x1 - 6 * x2 >= 0, name="protein_vitamin_D_balance")
model.addConstr(15 * x1 + 14 * x2 <= 75, name="kidney_support_index_max")
model.addConstr(5 * x1 + 25 * x2 <= 189, name="cardiovascular_support_index_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Grams of protein: {x1.varValue}")
    print(f"Milligrams of vitamin D: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
