
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(5, vtype=gp.GRB.INTEGER, name=["packs of paper plates", "lightbulbs", "cookies", "packs of napkins", "cartons of milk"])

    # Set objective function
    m.setObjective(7*x[0] + 8*x[1] + 5*x[2] + 1*x[3] + 9*x[4], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(0.47*x[0] + 0.26*x[1] + 0.83*x[4] >= 8)
    m.addConstr(8*x[1] - 2*x[2] + 10*x[4] >= 0)
    m.addConstr(0.26*x[1] + 0.78*x[3] <= 63)
    m.addConstr(0.47*x[0] + 0.29*x[2] <= 41)
    m.addConstr(0.29*x[2] + 0.83*x[4] <= 15)
    m.addConstr(0.47*x[0] + 0.78*x[3] <= 34)
    m.addConstr(0.47*x[0] + 0.83*x[4] <= 74)
    m.addConstr(0.26*x[1] + 0.83*x[4] <= 69)
    m.addConstr(0.26*x[1] + 0.29*x[2] <= 30)
    m.addConstr(0.47*x[0] + 0.26*x[1] + 0.78*x[3] <= 70)
    m.addConstr(0.29*x[2] + 0.78*x[3] + 0.83*x[4] <= 56)
    m.addConstr(0.47*x[0] + 0.26*x[1] + 0.83*x[4] <= 41)
    m.addConstr(0.47*x[0] + 0.26*x[1] + 0.29*x[2] <= 48)
    m.addConstr(0.26*x[1] + 0.78*x[3] + 0.83*x[4] <= 70)
    m.addConstr(0.26*x[1] + 0.29*x[2] + 0.83*x[4] <= 51)
    m.addConstr(0.26*x[1] + 0.29*x[2] + 0.78*x[3] <= 61)
    m.addConstr(0.47*x[0] + 0.26*x[1] + 0.29*x[2] + 0.78*x[3] + 0.83*x[4] <= 61)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
