
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='packs_of_paper_plates', vtype=gurobi.GRB.INTEGER)  # packs of paper plates
x2 = m.addVar(name='lightbulbs', vtype=gurobi.GRB.INTEGER)  # lightbulbs
x3 = m.addVar(name='cookies', vtype=gurobi.GRB.INTEGER)  # cookies
x4 = m.addVar(name='packs_of_napkins', vtype=gurobi.GRB.INTEGER)  # packs of napkins
x5 = m.addVar(name='cartons_of_milk', vtype=gurobi.GRB.INTEGER)  # cartons of milk

# Define the objective function
m.setObjective(7 * x1 + 8 * x2 + 5 * x3 + x4 + 9 * x5, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.47 * x1 + 0.26 * x2 + 0.83 * x5 >= 8)
m.addConstr(8 * x2 - 2 * x3 + 10 * x5 >= 0)
m.addConstr(0.26 * x2 + 0.78 * x4 <= 63)
m.addConstr(0.47 * x1 + 0.29 * x3 <= 41)
m.addConstr(0.29 * x3 + 0.83 * x5 <= 15)
m.addConstr(0.47 * x1 + 0.78 * x4 <= 34)
m.addConstr(0.47 * x1 + 0.83 * x5 <= 74)
m.addConstr(0.26 * x2 + 0.83 * x5 <= 69)
m.addConstr(0.26 * x2 + 0.29 * x3 <= 30)
m.addConstr(0.47 * x1 + 0.26 * x2 + 0.78 * x4 <= 70)
m.addConstr(0.29 * x3 + 0.78 * x4 + 0.83 * x5 <= 56)
m.addConstr(0.47 * x1 + 0.26 * x2 + 0.83 * x5 <= 41)
m.addConstr(0.47 * x1 + 0.26 * x2 + 0.29 * x3 <= 48)
m.addConstr(0.26 * x2 + 0.78 * x4 + 0.83 * x5 <= 70)
m.addConstr(0.26 * x2 + 0.29 * x3 + 0.83 * x5 <= 51)
m.addConstr(0.26 * x2 + 0.29 * x3 + 0.78 * x4 <= 61)
m.addConstr(0.47 * x1 + 0.26 * x2 + 0.29 * x3 + 0.78 * x4 + 0.83 * x5 <= 61)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('packs of paper plates: ', x1.varValue)
    print('lightbulbs: ', x2.varValue)
    print('cookies: ', x3.varValue)
    print('packs of napkins: ', x4.varValue)
    print('cartons of milk: ', x5.varValue)
else:
    print('The model is infeasible')
