
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Paul", "Bill", "Ringo", "Jean", "Mary"])


    # Set objective function
    m.setObjective(5*x[0] + 3*x[1] + 1*x[2] + 1*x[3] + 6*x[4], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11*x[3] + 23*x[4] >= 33)
    m.addConstr(17*x[0] + 23*x[4] >= 20)
    m.addConstr(13*x[1] + 11*x[3] >= 23)
    m.addConstr(17*x[0] + 13*x[1] + 20*x[2] + 11*x[3] + 23*x[4] >= 23)
    m.addConstr(15*x[0] + 19*x[2] >= 60)
    m.addConstr(9*x[3] + 22*x[4] >= 57)
    m.addConstr(12*x[1] + 9*x[3] >= 58)
    m.addConstr(19*x[2] + 9*x[3] >= 66)
    m.addConstr(15*x[0] + 12*x[1] >= 34)
    m.addConstr(12*x[1] + 19*x[2] + 9*x[3] >= 45)
    m.addConstr(12*x[1] + 19*x[2] + 22*x[4] >= 45)
    m.addConstr(15*x[0] + 19*x[2] + 22*x[4] >= 45)
    m.addConstr(12*x[1] + 19*x[2] + 9*x[3] >= 58)
    m.addConstr(12*x[1] + 19*x[2] + 22*x[4] >= 58)
    m.addConstr(15*x[0] + 19*x[2] + 22*x[4] >= 58)
    m.addConstr(12*x[1] + 19*x[2] + 9*x[3] >= 53)
    m.addConstr(12*x[1] + 19*x[2] + 22*x[4] >= 53)
    m.addConstr(15*x[0] + 19*x[2] + 22*x[4] >= 53)
    m.addConstr(15*x[0] + 12*x[1] + 19*x[2] + 9*x[3] + 22*x[4] >= 53)
    m.addConstr(4*x[2] + 5*x[3] >= 25)
    m.addConstr(18*x[0] + 4*x[2] >= 41)
    m.addConstr(2*x[1] + 4*x[2] >= 44)
    m.addConstr(5*x[3] + 16*x[4] >= 25)
    m.addConstr(18*x[0] + 2*x[1] >= 20)
    m.addConstr(18*x[0] + 16*x[4] >= 26)
    m.addConstr(18*x[0] + 2*x[1] + 4*x[2] + 5*x[3] + 16*x[4] >= 26)
    # ... (rest of the constraints)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
