
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Supplement Cost")

# Create variables
calcium = model.addVar(vtype=GRB.CONTINUOUS, name="calcium")
vitamin_e = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_e")

# Set objective function
model.setObjective(5.76 * calcium + 4.41 * vitamin_e, GRB.MINIMIZE)

# Add constraints
model.addConstr(20 * calcium + 13 * vitamin_e >= 48, "immune_support_min")
model.addConstr(-9 * calcium + 10 * vitamin_e >= 0, "calcium_vitamin_e_ratio")
model.addConstr(20 * calcium + 13 * vitamin_e <= 129, "immune_support_max")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Milligrams of Calcium: {calcium.x}')
    print(f'Milligrams of Vitamin E: {vitamin_e.x}')
    print(f'Objective Value: {model.objVal}')
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f'Optimization ended with status {model.status}.')

