
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(lb=0, name="milligrams_of_calcium")
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_E")

# Set the objective function
m.setObjective(5.76*x1 + 4.41*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x1 + 13*x2 >= 48, "Immune_Support_Index_Min")
m.addConstr(-9*x1 + 10*x2 >= 0, "Calcium_Vitamin_E_Balance")
m.addConstr(20*x1 + 13*x2 <= 129, "Total_Immune_Support_Max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Calcium: {x1.x}")
    print(f"Milligrams of Vitamin E: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
