
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_calcium", lb=0)  # Assuming non-negative
    x2 = model.addVar(name="milligrams_of_vitamin_E", lb=0)  # Assuming non-negative

    # Objective function
    model.setObjective(5.76 * x1 + 4.41 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20 * x1 + 13 * x2 >= 48, name="immune_support_index_min")
    model.addConstr(-9 * x1 + 10 * x2 >= 0, name="vitamin_E_calcium_balance")
    model.addConstr(20 * x1 + 13 * x2 <= 231, name="immune_support_index_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of calcium: {x1.varValue}")
        print(f"Milligrams of vitamin E: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
