
from gurobipy import Model, GRB

# Create a new model
m = Model("military_optimization")

# Create variables
reconnaissance_troops = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
light_infantry_companies = m.addVar(vtype=GRB.INTEGER, name="light_infantry_companies")

# Set objective function
m.setObjective(9 * reconnaissance_troops + 5 * light_infantry_companies, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8.6 * reconnaissance_troops + 2.79 * light_infantry_companies >= 45, "fun_factor_min")
m.addConstr(9 * reconnaissance_troops - 5 * light_infantry_companies >= 0, "troop_ratio")
m.addConstr(8.6 * reconnaissance_troops + 2.79 * light_infantry_companies <= 83, "fun_factor_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Reconnaissance Troops: {reconnaissance_troops.x}")
    print(f"  Light Infantry Companies: {light_infantry_companies.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

