
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x2 = m.addVar(vtype=GRB.INTEGER, name="light_infantry_companies")

# Set the objective function
m.setObjective(9*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(8.6*x1 + 2.79*x2 >= 45, "fun_factor_min")
m.addConstr(9*x1 - 5*x2 >= 0, "troops_vs_companies")
m.addConstr(8.6*x1 + 2.79*x2 <= 83, "fun_factor_max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Reconnaissance troops: {x1.x}")
    print(f"Light infantry companies: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
