
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x1 = model.addVar(lb=0, name="reconnaissance_troops")  # Non-fractional, non-negative
x2 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="light_infantry_companies")  # Integer, non-negative

# Objective function
model.setObjective(9 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(8.6 * x1 + 2.79 * x2 >= 45, name="fun_factor_min")
model.addConstr(8.6 * x1 + 2.79 * x2 <= 83, name="fun_factor_max")
model.addConstr(9 * x1 - 5 * x2 >= 0, name="troops_vs_companies")

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Reconnaissance troops: {x1.varValue}")
    print(f"Light infantry companies: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
