
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
knishes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="knishes")
peanutbutter_sandwiches = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")
apples = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apples")
strawberries = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberries")
fruit_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
hamburgers = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hamburgers")


# Set objective function
m.setObjective(7*knishes + 9*peanutbutter_sandwiches + 2*apples + 3*strawberries + 6*fruit_salads + 9*hamburgers, GRB.MINIMIZE)

# Add constraints

m.addConstr(4*peanutbutter_sandwiches + 4*hamburgers >= 43)
m.addConstr(3*apples + 12*strawberries >= 38)
m.addConstr(4*knishes + 3*apples >= 40)
m.addConstr(12*strawberries + 4*hamburgers >= 18)
m.addConstr(3*apples + 1*fruit_salads >= 25)
m.addConstr(4*knishes + 3*apples + 12*strawberries >= 27)
m.addConstr(4*peanutbutter_sandwiches + 3*apples + 12*strawberries >= 27)
m.addConstr(4*knishes + 3*apples + 1*fruit_salads >= 27)
m.addConstr(3*apples + 1*fruit_salads + 4*hamburgers >= 27)
m.addConstr(4*knishes + 3*apples + 12*strawberries >= 38)
m.addConstr(4*peanutbutter_sandwiches + 3*apples + 12*strawberries >= 38)
m.addConstr(4*knishes + 3*apples + 1*fruit_salads >= 38)
m.addConstr(3*apples + 1*fruit_salads + 4*hamburgers >= 38)


# ... (rest of the constraints from the JSON, following the same pattern)

m.addConstr(4 * knishes + 4 * peanutbutter_sandwiches + 3 * apples + 12 * strawberries + fruit_salads + 4 * hamburgers <= 268)
m.addConstr(8 * knishes + 3 * peanutbutter_sandwiches + 12 * apples + 5 * strawberries + 14 * fruit_salads + 10 * hamburgers <= 175)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

