
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("minimize_work_hours")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Mary")
    x1 = model.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")


    # Set objective function
    model.setObjective(6.47 * x0 + 9.14 * x1, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7 * x0 + 1 * x1 >= 30, "paperwork_competence_lower_bound")
    model.addConstr(8 * x0 - 5 * x1 >= 0, "work_balance")
    model.addConstr(7 * x0 + 1 * x1 <= 71, "paperwork_competence_upper_bound")



    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimal objective value: {model.objVal}")
        print(f"Hours worked by Mary: {x0.x}")
        print(f"Hours worked by Bobby: {x1.x}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
