
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Mary", vtype=gurobi.GRB.INTEGER) # integer hours for Mary
    x2 = model.addVar(name="hours_worked_by_Bobby") # continuous hours for Bobby

    # Objective function
    model.setObjective(6.47 * x1 + 9.14 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7 * x1 + x2 >= 30)
    model.addConstr(8 * x1 - 5 * x2 >= 0)
    model.addConstr(7 * x1 + x2 <= 71)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Mary: {x1.varValue}")
        print(f"Hours worked by Bobby: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
