
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
    apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")
    cherry_pies = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="cherry_pies")
    green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")

    # Set objective function
    m.setObjective(4 * bananas + 9 * apple_pies + 2 * cherry_pies + 8 * green_beans, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10 * bananas + 7 * apple_pies + 20 * cherry_pies + 9 * green_beans <= 169, "c0")
    m.addConstr(2 * bananas + 22 * apple_pies + 7 * cherry_pies + 6 * green_beans <= 212, "c1")
    m.addConstr(7 * apple_pies + 9 * green_beans >= 18, "c2")
    m.addConstr(10 * bananas + 20 * cherry_pies >= 21, "c3")
    m.addConstr(20 * cherry_pies + 9 * green_beans >= 37, "c4")
    m.addConstr(10 * bananas + 20 * cherry_pies + 9 * green_beans >= 40, "c5")
    m.addConstr(10 * bananas + 7 * apple_pies + 20 * cherry_pies >= 40, "c6")
    m.addConstr(10 * bananas + 20 * cherry_pies + 9 * green_beans >= 33, "c7")
    m.addConstr(10 * bananas + 7 * apple_pies + 20 * cherry_pies >= 33, "c8")
    m.addConstr(10 * bananas + 7 * apple_pies + 20 * cherry_pies + 9 * green_beans >= 33, "c9")
    m.addConstr(22 * apple_pies + 6 * green_beans >= 33, "c10")
    m.addConstr(2 * bananas + 7 * cherry_pies >= 35, "c11")
    m.addConstr(2 * bananas + 22 * apple_pies + 6 * green_beans >= 28, "c12")
    m.addConstr(2 * bananas + 22 * apple_pies + 7 * cherry_pies >= 28, "c13")
    m.addConstr(2 * bananas + 22 * apple_pies + 6 * green_beans >= 33, "c14")
    m.addConstr(2 * bananas + 22 * apple_pies + 7 * cherry_pies >= 33, "c15")
    m.addConstr(2 * bananas + 22 * apple_pies + 7 * cherry_pies + 6 * green_beans >= 33, "c16")
    m.addConstr(-8 * bananas + 10 * green_beans >= 0, "c17")
    m.addConstr(8 * bananas - 2 * apple_pies >= 0, "c18")
    m.addConstr(-3 * bananas + 9 * cherry_pies + 4 * green_beans >= 0, "c19")
    m.addConstr(10 * bananas + 20 * cherry_pies + 9 * green_beans <= 45, "c20")
    m.addConstr(7 * apple_pies + 20 * cherry_pies + 9 * green_beans <= 82, "c21")
    m.addConstr(10 * bananas + 7 * apple_pies + 20 * cherry_pies <= 53, "c22")
    m.addConstr(22 * apple_pies + 6 * green_beans <= 122, "c23")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
