
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")
instant_ramen = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="instant_ramen")
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
cereal = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cereal")

# Set objective function
m.setObjective(8.28 * kale_salads + 9.48 * instant_ramen + 6.68 * green_beans + 2.59 * cereal, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * kale_salads + 1 * instant_ramen >= 34)
m.addConstr(6 * kale_salads + 3 * green_beans >= 52)
m.addConstr(6 * kale_salads + 5 * cereal >= 23)
m.addConstr(6 * kale_salads + 1 * instant_ramen + 3 * green_beans + 5 * cereal >= 23)
m.addConstr(1 * instant_ramen + 2 * green_beans >= 22)
m.addConstr(1 * instant_ramen + 9 * cereal >= 20)
m.addConstr(3 * kale_salads + 2 * green_beans >= 34)
m.addConstr(3 * kale_salads + 9 * cereal >= 15)
m.addConstr(3 * kale_salads + 1 * instant_ramen + 2 * green_beans + 9 * cereal >= 15)
m.addConstr(2 * instant_ramen + 10 * cereal >= 14)
m.addConstr(2 * instant_ramen + 10 * green_beans >= 19)
m.addConstr(10 * green_beans + 10 * cereal >= 8)
m.addConstr(6 * kale_salads + 10 * cereal >= 17)
m.addConstr(6 * kale_salads + 2 * instant_ramen + 10 * green_beans + 10 * cereal >= 17)
m.addConstr(9 * instant_ramen - 10 * green_beans >= 0)
m.addConstr(1 * instant_ramen + 5 * cereal <= 207)
m.addConstr(6 * kale_salads + 3 * green_beans <= 211)
m.addConstr(6 * kale_salads + 5 * cereal <= 203)
m.addConstr(6 * kale_salads + 1 * instant_ramen <= 166)
m.addConstr(3 * green_beans + 5 * cereal <= 133)
m.addConstr(6 * kale_salads + 1 * instant_ramen + 3 * green_beans <= 87)
m.addConstr(6 * kale_salads + 10 * cereal <= 49)
m.addConstr(2 * instant_ramen + 10 * green_beans <= 79)
m.addConstr(6 * kale_salads + 2 * instant_ramen <= 65)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

