
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
cheeseburgers = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
ham_sandwiches = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")
blueberry_pies = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")
corn_cobs = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")

# Set objective function
model.setObjective(4.45 * cheeseburgers + 7.62 * ham_sandwiches + 3.95 * blueberry_pies + 6.3 * corn_cobs, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * cheeseburgers + 3 * ham_sandwiches + 14 * blueberry_pies + 13 * corn_cobs <= 262, "c0")
model.addConstr(1 * cheeseburgers + 5 * ham_sandwiches + 12 * blueberry_pies + 8 * corn_cobs <= 289, "c1")
model.addConstr(3 * ham_sandwiches + 14 * blueberry_pies >= 39, "c2")
model.addConstr(6 * cheeseburgers + 13 * corn_cobs >= 59, "c3")
model.addConstr(12 * blueberry_pies + 8 * corn_cobs >= 70, "c4")
model.addConstr(1 * cheeseburgers + 12 * blueberry_pies >= 40, "c5")
model.addConstr(5 * ham_sandwiches + 8 * corn_cobs >= 72, "c6")
model.addConstr(5 * ham_sandwiches + 12 * blueberry_pies >= 27, "c7")
model.addConstr(-7 * cheeseburgers + 2 * ham_sandwiches + 6 * blueberry_pies >= 0, "c8")
model.addConstr(3 * ham_sandwiches + 14 * blueberry_pies <= 122, "c9")
model.addConstr(14 * blueberry_pies + 13 * corn_cobs <= 145, "c10")
model.addConstr(3 * ham_sandwiches + 13 * corn_cobs <= 205, "c11")
model.addConstr(6 * cheeseburgers + 13 * corn_cobs <= 76, "c12")
model.addConstr(6 * cheeseburgers + 14 * blueberry_pies <= 241, "c13")
model.addConstr(6 * cheeseburgers + 3 * ham_sandwiches <= 144, "c14")
model.addConstr(6 * cheeseburgers + 3 * ham_sandwiches + 14 * blueberry_pies + 13 * corn_cobs <= 144, "c15")
model.addConstr(1 * cheeseburgers + 8 * corn_cobs <= 169, "c16")
model.addConstr(1 * cheeseburgers + 5 * ham_sandwiches <= 272, "c17")
model.addConstr(12 * blueberry_pies + 8 * corn_cobs <= 209, "c18")
model.addConstr(5 * ham_sandwiches + 12 * blueberry_pies <= 101, "c19")
model.addConstr(1 * cheeseburgers + 5 * ham_sandwiches + 8 * corn_cobs <= 135, "c20")
model.addConstr(1 * cheeseburgers + 5 * ham_sandwiches + 12 * blueberry_pies + 8 * corn_cobs <= 135, "c21")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cheeseburgers: {cheeseburgers.x}")
    print(f"Ham Sandwiches: {ham_sandwiches.x}")
    print(f"Blueberry Pies: {blueberry_pies.x}")
    print(f"Corn Cobs: {corn_cobs.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

