
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="cheeseburgers", lb=0)
x1 = model.addVar(name="ham sandwiches", lb=0)
x2 = model.addVar(name="blueberry pies", lb=0)
x3 = model.addVar(name="corn cobs", lb=0)

# Define the objective function
model.setObjective(4.45 * x0 + 7.62 * x1 + 3.95 * x2 + 6.3 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * x1 + 14 * x2 >= 39)
model.addConstr(6 * x0 + 13 * x3 >= 59)
model.addConstr(12 * x2 + 8 * x3 >= 70)
model.addConstr(x0 + 12 * x2 >= 40)
model.addConstr(5 * x1 + 8 * x3 >= 72)
model.addConstr(5 * x1 + 12 * x2 >= 27)
model.addConstr(-7 * x0 + 2 * x1 + 6 * x2 >= 0)
model.addConstr(3 * x1 + 14 * x2 <= 122)
model.addConstr(14 * x2 + 13 * x3 <= 145)
model.addConstr(3 * x1 + 13 * x3 <= 205)
model.addConstr(6 * x0 + 13 * x3 <= 76)
model.addConstr(6 * x0 + 14 * x2 <= 241)
model.addConstr(6 * x0 + 3 * x1 <= 144)
model.addConstr(6 * x0 + 3 * x1 + 14 * x2 + 13 * x3 <= 144)
model.addConstr(x0 + 8 * x3 <= 169)
model.addConstr(x0 + 5 * x1 <= 272)
model.addConstr(12 * x2 + 8 * x3 <= 209)
model.addConstr(5 * x1 + 12 * x2 <= 101)
model.addConstr(x0 + 5 * x1 + 8 * x3 <= 135)
model.addConstr(x0 + 5 * x1 + 12 * x2 + 8 * x3 <= 135)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Cheeseburgers: ", x0.varValue)
    print("Ham sandwiches: ", x1.varValue)
    print("Blueberry pies: ", x2.varValue)
    print("Corn cobs: ", x3.varValue)
else:
    print("The model is infeasible")
