
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B12
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # grams of protein
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x2")  # milligrams of zinc

# Set objective function
m.setObjective(1.84*x0**2 + 6.46*x0*x1 + 4.61*x1**2 + 1.45*x1*x2 + 5.7*x0, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(19*x0 + 4*x1 >= 11)
m.addConstr(19*x0 + 6*x2 >= 15)
m.addConstr(19*x0 + 4*x1 + 6*x2 >= 15)
m.addConstr(6*x0 + 14*x1 >= 17)
m.addConstr(6*x0 + 8*x2 >= 26)
m.addConstr(6*x0**2 + 14*x1**2 + 8*x2**2 >= 27)
m.addConstr(6*x0 + 14*x1 + 8*x2 >= 27)
m.addConstr(5*x0 + 2*x2 >= 30)
m.addConstr(5*x0 + 2*x1 >= 33)
m.addConstr(2*x1 + 2*x2 >= 24)
m.addConstr(5*x0 + 2*x1 + 2*x2 >= 24)
m.addConstr(11*x0**2 + 20*x1**2 >= 14)
m.addConstr(20*x1 + 14*x2 >= 15)
m.addConstr(11*x0 + 14*x2 >= 24)
m.addConstr(11*x0 + 20*x1 + 14*x2 >= 24)
m.addConstr(8*x0 + 2*x1 >= 21)
m.addConstr(8*x0 + 20*x2 >= 23)
m.addConstr(2*x1 + 20*x2 >= 16)
m.addConstr(8*x0 + 2*x1 + 20*x2 >= 14)
m.addConstr(-5*x0**2 + 7*x1**2 >= 0)
m.addConstr(4*x1 + 6*x2 <= 70)
m.addConstr(5*x0**2 + 2*x1**2 <= 49)
m.addConstr(11*x0 + 14*x2 <= 75)
m.addConstr(2*x1**2 + 20*x2**2 <= 64)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

