
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="milligrams_of_vitamin_B12", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="grams_of_protein", lb=-gp.GRB.INFINITY)
x3 = m.addVar(name="milligrams_of_zinc", lb=0, type=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(1.84*x1**2 + 6.46*x1*x2 + 4.61*x2**2 + 1.45*x2*x3 + 5.7*x1, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(19*x1 <= 84)
m.addConstr(6*x1 <= 107)
m.addConstr(5*x1 <= 107)
m.addConstr(11*x1 <= 83)
m.addConstr(8*x1 <= 80)
m.addConstr(4*x2 <= 84)
m.addConstr(14*x2 <= 107)
m.addConstr(2*x2 <= 107)
m.addConstr(20*x2 <= 83)
m.addConstr(2*x2 <= 80)
m.addConstr(6*x3 <= 84)
m.addConstr(8*x3 <= 107)
m.addConstr(2*x3 <= 107)
m.addConstr(14*x3 <= 83)
m.addConstr(20*x3 <= 80)
m.addConstr(19*x1 + 4*x2 >= 11)
m.addConstr(19*x1 + 6*x3 >= 15)
m.addConstr(19*x1 + 4*x2 + 6*x3 >= 15)
m.addConstr(6*x1 + 14*x2 >= 17)
m.addConstr(6*x1 + 8*x3 >= 26)
m.addConstr(6*x1**2 + 14*x2**2 + 8*x3**2 >= 27)
m.addConstr(6*x1 + 14*x2 + 8*x3 >= 27)
m.addConstr(5*x1 + 2*x3 >= 30)
m.addConstr(5*x1 + 2*x2 >= 33)
m.addConstr(2*x2 + 2*x3 >= 24)
m.addConstr(5*x1 + 2*x2 + 2*x3 >= 24)
m.addConstr(11*x1**2 + 20*x2**2 >= 14)
m.addConstr(20*x2 + 14*x3 >= 15)
m.addConstr(11*x1 + 14*x3 >= 24)
m.addConstr(11*x1 + 20*x2 + 14*x3 >= 24)
m.addConstr(8*x1 + 2*x2 >= 21)
m.addConstr(8*x1 + 20*x3 >= 23)
m.addConstr(2*x2 + 20*x3 >= 16)
m.addConstr(8*x1 + 2*x2 + 20*x3 >= 14)
m.addConstr(-5*x1**2 + 7*x2**2 >= 0)
m.addConstr(4*x2 + 6*x3 <= 70)
m.addConstr(5*x1**2 + 2*x2**2 <= 49)
m.addConstr(11*x1 + 14*x3 <= 75)
m.addConstr(2*x2**2 + 20*x3**2 <= 64)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of vitamin B12: ", x1.varValue)
    print("Grams of protein: ", x2.varValue)
    print("Milligrams of zinc: ", x3.varValue)
else:
    print("No optimal solution found.")
