
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
lemons = m.addVar(vtype=gp.GRB.INTEGER, name="lemons")
chicken_thighs = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_thighs")
corn_cobs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
cheeseburgers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")

# Set objective function
m.setObjective(4.27 * lemons + 7.35 * chicken_thighs + 1.78 * corn_cobs + 6.68 * cheeseburgers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8.84 * chicken_thighs + 9.92 * corn_cobs + 7.71 * cheeseburgers >= 32)
m.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 9.92 * corn_cobs >= 32)
m.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 7.71 * cheeseburgers >= 32)
m.addConstr(8.84 * chicken_thighs + 9.92 * corn_cobs + 7.71 * cheeseburgers >= 52)
m.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 9.92 * corn_cobs >= 52)
m.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 7.71 * cheeseburgers >= 52)
m.addConstr(8.84 * chicken_thighs + 9.92 * corn_cobs + 7.71 * cheeseburgers >= 47)
m.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 9.92 * corn_cobs >= 47)
m.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 7.71 * cheeseburgers >= 47)
m.addConstr(6.51 * chicken_thighs + 5.58 * corn_cobs >= 49)
m.addConstr(4.0 * lemons + 6.51 * chicken_thighs + 1.41 * cheeseburgers >= 43)
m.addConstr(6.51 * chicken_thighs + 5.58 * corn_cobs + 1.41 * cheeseburgers >= 43)
m.addConstr(4.0 * lemons + 6.51 * chicken_thighs + 1.41 * cheeseburgers >= 47)
m.addConstr(6.51 * chicken_thighs + 5.58 * corn_cobs + 1.41 * cheeseburgers >= 47)
m.addConstr(9.92 * corn_cobs + 7.71 * cheeseburgers <= 196)
m.addConstr(4.64 * lemons + 7.71 * cheeseburgers <= 190)
m.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 7.71 * cheeseburgers <= 236)
m.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 9.92 * corn_cobs <= 204)
m.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 9.92 * corn_cobs + 7.71 * cheeseburgers <= 204)
m.addConstr(4.0 * lemons + 5.58 * corn_cobs <= 60)
m.addConstr(4.0 * lemons + 6.51 * chicken_thighs <= 69)
m.addConstr(4.0 * lemons + 1.41 * cheeseburgers <= 163)
m.addConstr(4.0 * lemons + 6.51 * chicken_thighs + 5.58 * corn_cobs <= 94)
m.addConstr(4.0 * lemons + 5.58 * corn_cobs + 1.41 * cheeseburgers <= 136)
m.addConstr(6.51 * chicken_thighs + 5.58 * corn_cobs + 1.41 * cheeseburgers <= 169)
m.addConstr(4.0 * lemons + 6.51 * chicken_thighs + 1.41 * cheeseburgers <= 211)
m.addConstr(4.0 * lemons + 6.51 * chicken_thighs + 5.58 * corn_cobs + 1.41 * cheeseburgers <= 211)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

