
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="lemons", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="chicken thighs", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="corn cobs")
    x4 = model.addVar(name="cheeseburgers")

    # Objective function
    model.setObjective(4.27 * x1 + 7.35 * x2 + 1.78 * x3 + 6.68 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4.64 * x1 <= 236)
    model.addConstr(4.0 * x1 <= 233)
    model.addConstr(8.84 * x2 <= 236)
    model.addConstr(6.51 * x2 <= 233)
    model.addConstr(9.92 * x3 <= 236)
    model.addConstr(5.58 * x3 <= 233)
    model.addConstr(7.71 * x4 <= 236)
    model.addConstr(1.41 * x4 <= 233)

    model.addConstr(8.84 * x2 + 9.92 * x3 + 7.71 * x4 >= 32)
    model.addConstr(4.64 * x1 + 8.84 * x2 + 9.92 * x3 >= 32)
    model.addConstr(4.64 * x1 + 8.84 * x2 + 7.71 * x4 >= 32)
    model.addConstr(8.84 * x2 + 9.92 * x3 + 7.71 * x4 >= 52)
    model.addConstr(4.64 * x1 + 8.84 * x2 + 9.92 * x3 >= 52)
    model.addConstr(4.64 * x1 + 8.84 * x2 + 7.71 * x4 >= 52)
    model.addConstr(8.84 * x2 + 9.92 * x3 + 7.71 * x4 >= 47)
    model.addConstr(4.64 * x1 + 8.84 * x2 + 9.92 * x3 >= 47)
    model.addConstr(4.64 * x1 + 8.84 * x2 + 7.71 * x4 >= 47)

    model.addConstr(6.51 * x2 + 5.58 * x3 >= 49)
    model.addConstr(4.0 * x1 + 6.51 * x2 + 1.41 * x4 >= 43)
    model.addConstr(6.51 * x2 + 5.58 * x3 + 1.41 * x4 >= 43)
    model.addConstr(4.0 * x1 + 6.51 * x2 + 1.41 * x4 >= 47)
    model.addConstr(6.51 * x2 + 5.58 * x3 + 1.41 * x4 >= 47)

    model.addConstr(9.92 * x3 + 7.71 * x4 <= 196)
    model.addConstr(4.64 * x1 + 7.71 * x4 <= 190)
    model.addConstr(4.64 * x1 + 8.84 * x2 + 7.71 * x4 <= 236)
    model.addConstr(4.64 * x1 + 8.84 * x2 + 9.92 * x3 <= 204)
    model.addConstr(4.64 * x1 + 8.84 * x2 + 9.92 * x3 + 7.71 * x4 <= 204)

    model.addConstr(4.0 * x1 + 5.58 * x3 <= 60)
    model.addConstr(4.0 * x1 + 6.51 * x2 <= 69)
    model.addConstr(4.0 * x1 + 1.41 * x4 <= 163)
    model.addConstr(4.0 * x1 + 6.51 * x2 + 5.58 * x3 <= 94)
    model.addConstr(4.0 * x1 + 5.58 * x3 + 1.41 * x4 <= 136)
    model.addConstr(6.51 * x2 + 5.58 * x3 + 1.41 * x4 <= 169)
    model.addConstr(4.0 * x1 + 6.51 * x2 + 1.41 * x4 <= 211)
    model.addConstr(4.0 * x1 + 6.51 * x2 + 5.58 * x3 + 1.41 * x4 <= 211)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Lemon: ", x1.varValue)
        print("Chicken thighs: ", x2.varValue)
        print("Corn cobs: ", x3.varValue)
        print("Cheeseburgers: ", x4.varValue)
    else:
        print("No optimal solution found")

optimize_problem()
