
import gurobipy as gp

# Create a new model
model = gp.Model("resource_allocation")

# Create variables
ringo = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")


# Set objective function
model.setObjective(3.28 * ringo + 1.11 * bobby + 8.98 * dale + 7.8 * paul + 1.77 * jean + 2.5 * laura + 3.07 * mary, gp.GRB.MAXIMIZE)

# Add constraints

model.addConstr(12*ringo + 3*dale + 9*jean >= 23)
model.addConstr(3*bobby + 3*dale + 11*laura >= 23)
model.addConstr(12*ringo + 3*bobby + 7*paul >= 23)
model.addConstr(3*bobby + 7*paul + 9*jean >= 23)

model.addConstr(12*ringo + 3*dale + 9*jean >= 21)
model.addConstr(3*bobby + 3*dale + 11*laura >= 21)
model.addConstr(12*ringo + 3*bobby + 7*paul >= 21)
model.addConstr(3*bobby + 7*paul + 9*jean >= 21)

model.addConstr(12*ringo + 3*dale + 9*jean >= 26)
model.addConstr(3*bobby + 3*dale + 11*laura >= 26)
model.addConstr(12*ringo + 3*bobby + 7*paul >= 26)
model.addConstr(3*bobby + 7*paul + 9*jean >= 26)

model.addConstr(12*ringo + 3*dale + 9*jean >= 37)
model.addConstr(3*bobby + 3*dale + 11*laura >= 37)
model.addConstr(12*ringo + 3*bobby + 7*paul >= 37)
model.addConstr(3*bobby + 7*paul + 9*jean >= 37)


model.addConstr(6 * bobby + 2 * jean >= 16)
model.addConstr(12 * ringo + 1 * mary >= 22)
model.addConstr(12 * paul + 14 * laura >= 20)
model.addConstr(2 * jean + 14 * laura >= 11)
model.addConstr(12 * ringo + 12 * paul >= 11)
model.addConstr(12 * paul + 2 * jean >= 24)


model.addConstr(14*ringo + 5*bobby <= 110)
model.addConstr(12*ringo + 3*dale <= 294)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", model.status)

