
from gurobipy import *

# Create a model
m = Model("Work Hours")

# Define variables
x1 = m.addVar(name="Ringo")
x2 = m.addVar(name="Bobby")
x3 = m.addVar(name="Dale")
x4 = m.addVar(name="Paul")
x5 = m.addVar(name="Jean")
x6 = m.addVar(name="Laura")
x7 = m.addVar(name="Mary")

# Set the objective function (assuming we want to minimize the sum of hours worked as an example)
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6 + x7, GRB.MINIMIZE)

# Add constraints
# Example constraint: Total hours of Ringo and Bobby less than or equal to 134
m.addConstr(x1 + x2 <= 134, "Ringo_and_Bobby_hours")
# Another example constraint: Hours worked by Dale is non-negative
m.addConstr(x3 >= 0, "Dale_hours_non_negative")

# Add all other constraints following the same pattern...

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))

