
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="Ringo", lb=-gp.GRB.INFINITY)  # hours worked by Ringo
x2 = m.addVar(name="Bobby", lb=-gp.GRB.INFINITY)  # hours worked by Bobby
x3 = m.addVar(name="Dale", lb=-gp.GRB.INFINITY)   # hours worked by Dale
x4 = m.addVar(name="Paul", lb=-gp.GRB.INFINITY)   # hours worked by Paul
x5 = m.addVar(name="Jean", lb=-gp.GRB.INFINITY)   # hours worked by Jean
x6 = m.addVar(name="Laura", lb=-gp.GRB.INFINITY)  # hours worked by Laura
x7 = m.addVar(name="Mary", lb=-gp.GRB.INFINITY)   # hours worked by Mary

# Objective function
m.setObjective(3.28*x1 + 1.11*x2 + 8.98*x3 + 7.8*x4 + 1.77*x5 + 2.5*x6 + 3.07*x7, gp.GRB.MAXIMIZE)

# Constraints
# Ringo's ratings
m.addConstr(12*x1 <= 294, "Ringo_computer")
m.addConstr(12*x1 <= 173, "Ringo_work_quality")
m.addConstr(14*x1 <= 197, "Ringo_organization")
m.addConstr(10*x1 <= 167, "Ringo_paperwork")

# Bobby's ratings
m.addConstr(3*x2 <= 294, "Bobby_computer")
m.addConstr(6*x2 <= 173, "Bobby_work_quality")
m.addConstr(5*x2 <= 197, "Bobby_organization")
m.addConstr(3*x2 <= 167, "Bobby_paperwork")

# Dale's ratings
m.addConstr(3*x3 <= 294, "Dale_computer")
m.addConstr(10*x3 <= 173, "Dale_work_quality")
m.addConstr(6*x3 <= 197, "Dale_organization")
m.addConstr(13*x3 <= 167, "Dale_paperwork")

# Paul's ratings
m.addConstr(7*x4 <= 294, "Paul_computer")
m.addConstr(12*x4 <= 173, "Paul_work_quality")
m.addConstr(11*x4 <= 197, "Paul_organization")
m.addConstr(4*x4 <= 167, "Paul_paperwork")

# Jean's ratings
m.addConstr(9*x5 <= 294, "Jean_computer")
m.addConstr(2*x5 <= 173, "Jean_work_quality")
m.addConstr(5*x5 <= 197, "Jean_organization")
m.addConstr(8*x5 <= 167, "Jean_paperwork")

# Laura's ratings
m.addConstr(11*x6 <= 294, "Laura_computer")
m.addConstr(14*x6 <= 173, "Laura_work_quality")
m.addConstr(x6 <= 197, "Laura_organization")
m.addConstr(10*x6 <= 167, "Laura_paperwork")

# Mary's ratings
m.addConstr(14*x7 <= 294, "Mary_computer")
m.addConstr(x7 <= 173, "Mary_work_quality")
m.addConstr(6*x7 <= 197, "Mary_organization")
m.addConstr(5*x7 <= 167, "Mary_paperwork")

# Computer competence constraints
m.addConstr(12*x1 + 3*x3 + 9*x5 >= 23, "computer_1")
m.addConstr(3*x2 + 3*x3 + 11*x6 >= 23, "computer_2")
m.addConstr(12*x1 + 3*x2 + 7*x4 >= 23, "computer_3")
m.addConstr(3*x2 + 7*x4 + 9*x5 >= 23, "computer_4")

# ... add all other constraints similarly

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Ringo: ", x1.varValue)
    print("Bobby: ", x2.varValue)
    print("Dale: ", x3.varValue)
    print("Paul: ", x4.varValue)
    print("Jean: ", x5.varValue)
    print("Laura: ", x6.varValue)
    print("Mary: ", x7.varValue)
else:
    print("No solution found")
