
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")


    # Set objective function
    m.setObjective(5.01*x0 + 2.79*x1 + 4.52*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(16*x1 + 21*x2 >= 39, "c1")
    m.addConstr(16*x0 + 8*x1 >= 21, "c2")
    m.addConstr(16*x0 + 8*x1 + 21*x2 >= 45, "c3")
    m.addConstr(8*x1 + 26*x2 >= 72, "c4")
    m.addConstr(8*x0 + 7*x1 >= 33, "c5")
    m.addConstr(12*x0 + 21*x2 >= 32, "c6")
    m.addConstr(12*x0 + 19*x1 >= 48, "c7")
    m.addConstr(4*x0 - 2*x2 >= 0, "c8")
    m.addConstr(-7*x0 + 7*x1 >= 0, "c9")
    m.addConstr(8*x0 + 26*x2 <= 233, "c10")
    m.addConstr(8*x0 + 7*x1 <= 231, "c11")
    m.addConstr(12*x0 + 19*x1 + 21*x2 <= 81, "c12")

    # Resource Constraints
    m.addConstr(16*x0 <= 170, "r0_zinc")
    m.addConstr(8*x0 <= 235, "r1_zinc")
    m.addConstr(12*x0 <= 175, "r2_zinc")
    m.addConstr(8*x1 <= 170, "r0_magnesium")
    m.addConstr(7*x1 <= 235, "r1_magnesium")
    m.addConstr(19*x1 <= 175, "r2_magnesium")
    m.addConstr(21*x2 <= 170, "r0_vitamin_b4")
    m.addConstr(26*x2 <= 235, "r1_vitamin_b4")
    m.addConstr(21*x2 <= 175, "r2_vitamin_b4")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        for v in m.getVars():
            print('{}: {}'.format(v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

