
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams_of_zinc", lb=0)
    x1 = model.addVar(name="milligrams_of_magnesium", lb=0)
    x2 = model.addVar(name="milligrams_of_vitamin_B4", lb=0)

    # Objective function
    model.setObjective(5.01*x0 + 2.79*x1 + 4.52*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8*x0 + 8*x1 + 21*x2 >= 39)
    model.addConstr(16*x0 + 8*x1 >= 21)
    model.addConstr(16*x0 + 8*x1 + 21*x2 >= 45)
    model.addConstr(7*x1 + 26*x2 >= 72)
    model.addConstr(8*x0 + 7*x1 >= 33)
    model.addConstr(8*x0 + 7*x1 + 26*x2 >= 33)
    model.addConstr(8*x0 + 26*x2 <= 233)
    model.addConstr(8*x0 + 7*x1 <= 231)
    model.addConstr(12*x0 + 21*x2 >= 32)
    model.addConstr(12*x0 + 19*x1 >= 48)
    model.addConstr(12*x0 + 19*x1 + 21*x2 <= 81)
    model.addConstr(4*x0 - 2*x2 >= 0)
    model.addConstr(-7*x0 + 7*x1 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of zinc: {x0.varValue}")
        print(f"Milligrams of magnesium: {x1.varValue}")
        print(f"Milligrams of vitamin B4: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
