
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
bananas = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")
steaks = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="steaks")
strawberries = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberries")
blueberry_pies = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="blueberry_pies")
bowls_of_cereal = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_cereal")
slices_of_pizza = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="slices_of_pizza")
black_beans = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="black_beans")


# Set objective
obj = 8.53*bananas**2 + 4.14*bananas*strawberries + 2.44*bananas*blueberry_pies + 3.18*bananas*bowls_of_cereal + 4.68*bananas*slices_of_pizza + 7.56*bananas*black_beans + 3.79*steaks**2 + 8.2*steaks*strawberries + 8.89*steaks*blueberry_pies + 3.94*steaks*bowls_of_cereal + 8.98*steaks*slices_of_pizza + 7.06*steaks*black_beans + 4.06*strawberries**2 + 7.33*strawberries*bowls_of_cereal + 4.73*strawberries*slices_of_pizza + 5.2*strawberries*black_beans + 9.92*blueberry_pies*slices_of_pizza + 9.3*blueberry_pies*black_beans + 9.03*bowls_of_cereal*slices_of_pizza + 7.13*bowls_of_cereal*black_beans + 4.36*slices_of_pizza*black_beans + 3.91*black_beans**2 + 4.77*bananas + 1.16*steaks + 7.21*strawberries + 1.55*blueberry_pies + 6.88*bowls_of_cereal + 7.0*slices_of_pizza + 8.24*black_beans

m.setObjective(obj, GRB.MINIMIZE)

# Add constraints

# Resource constraints
m.addConstr(3*steaks + 8*slices_of_pizza >= 26, "r0_constraint1")
m.addConstr(3*bananas + 1*black_beans >= 16, "r0_constraint2")
# ... (rest of the constraints from the JSON "constraints" field)
m.addConstr(3 * bananas + 3 * steaks + 6 * strawberries + blueberry_pies + 5 * bowls_of_cereal + 8 * slices_of_pizza + black_beans <= 208, "sourness_ub")
m.addConstr(5 * bananas + 3 * steaks + 3 * strawberries + blueberry_pies + 6 * bowls_of_cereal + 2 * slices_of_pizza + 5 * black_beans <= 295, "umami_ub")
m.addConstr(5 * bananas + 6 * steaks + 4 * strawberries + 3 * blueberry_pies + bowls_of_cereal + 3 * slices_of_pizza + 8 * black_beans <= 174, "iron_ub")
m.addConstr(bananas + 7 * steaks + 4 * strawberries + 7 * blueberry_pies + 6 * bowls_of_cereal + 2 * slices_of_pizza + 6 * black_beans <= 318, "carbs_ub")
m.addConstr(bananas + 2 * steaks + 4 * strawberries + 3 * blueberry_pies + bowls_of_cereal + 7 * slices_of_pizza + black_beans <= 142, "calcium_ub")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

