
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # bananas
x1 = m.addVar(name="x1", lb=0)  # steaks
x2 = m.addVar(name="x2", lb=0)  # strawberries
x3 = m.addVar(name="x3", lb=0)  # blueberry pies
x4 = m.addVar(name="x4", lb=0)  # bowls of cereal
x5 = m.addVar(name="x5", lb=0)  # slices of pizza
x6 = m.addVar(name="x6", lb=0)  # black beans

# Objective function
m.setObjective(8.53*x0**2 + 4.14*x0*x2 + 2.44*x0*x3 + 3.18*x0*x5 + 4.68*x0*x6 + 
               3.79*x1**2 + 8.2*x1*x2 + 8.89*x1*x3 + 3.94*x1*x4 + 8.98*x1*x5 + 7.06*x1*x6 + 
               4.06*x2**2 + 7.33*x2*x4 + 4.73*x2*x5 + 5.2*x2*x6 + 9.92*x3*x5 + 9.3*x3*x6 + 
               9.03*x4*x5 + 7.13*x4*x6 + 4.36*x5*x6 + 3.91*x6**2 + 4.77*x0 + 1.16*x1 + 
               7.21*x2 + 1.55*x3 + 6.88*x4 + 7.0*x5 + 8.24*x6, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(3*x0 <= 208)
m.addConstr(5*x0 <= 295)
m.addConstr(5*x0 <= 174)
m.addConstr(x0 <= 142)
m.addConstr(3*x1 <= 208)
m.addConstr(3*x1 <= 295)
m.addConstr(6*x1 <= 174)
m.addConstr(7*x1 <= 142)
m.addConstr(6*x2 <= 208)
m.addConstr(3*x2 <= 295)
m.addConstr(4*x2 <= 174)
m.addConstr(4*x2 <= 142)
m.addConstr(x3 <= 208)
m.addConstr(x3 <= 295)
m.addConstr(3*x3 <= 174)
m.addConstr(7*x3 <= 142)
m.addConstr(5*x4 <= 208)
m.addConstr(6*x4 <= 295)
m.addConstr(x4 <= 174)
m.addConstr(6*x4 <= 142)
m.addConstr(8*x5 <= 208)
m.addConstr(2*x5 <= 295)
m.addConstr(3*x5 <= 174)
m.addConstr(2*x5 <= 142)
m.addConstr(x6 <= 208)
m.addConstr(5*x6 <= 295)
m.addConstr(8*x6 <= 174)
m.addConstr(6*x6 <= 142)
m.addConstr(3*x1 + 8*x5 >= 26)
m.addConstr(3*x0 + x6 >= 16)
m.addConstr(x0**2 + x1**2 >= 10)
m.addConstr(x3 + x4 >= 18)
m.addConstr(x2**2 + x6**2 >= 20)
m.addConstr(x2**2 + x4**2 + x6**2 >= 29)
m.addConstr(3*x1 + x3 + x4 >= 29)
m.addConstr(x1**2 + x2**2 + x6**2 >= 29)
m.addConstr(x0 + x1 + x6 >= 29)
m.addConstr(x2**2 + x4**2 + x6**2 >= 26)
m.addConstr(3*x1 + x3 + x4 >= 26)
m.addConstr(3*x1 + x2 + x6 >= 26)
m.addConstr(x0 + x1 + x6 >= 26)
m.addConstr(x2**2 + x4**2 + x6**2 >= 17)
m.addConstr(x1**2 + x3**2 + x4**2 >= 17)
m.addConstr(3*x1 + x2 + x6 >= 17)
m.addConstr(x0**2 + x1**2 + x6**2 >= 17)
m.addConstr(x2 + x4 + x6 >= 19)
m.addConstr(3*x1 + x3 + x4 >= 19)
m.addConstr(x1**2 + x2**2 + x6**2 >= 19)
m.addConstr(x0**2 + x1**2 + x6**2 >= 19)
m.addConstr(x0 + x1 + x2 + x3 + x4 + x5 + x6 >= 19)
m.addConstr(x3**2 + x5**2 >= 24)
m.addConstr(x2 + x5 >= 41)
m.addConstr(x5 + x6 >= 30)
m.addConstr(x0 + x4 >= 33)
m.addConstr(x0**2 + x1**2 >= 39)
m.addConstr(x4 + x6 >= 39)
m.addConstr(x0 + x5 >= 40)
m.addConstr(x0 + x3 >= 22)
m.addConstr(x1 + x6 >= 19)
m.addConstr(x3 + x6 >= 35)
m.addConstr(x4**2 + x5**2 >= 16)
m.addConstr(x0**2 + x2**2 + x6**2 >= 41)
m.addConstr(x0 + x1 + x3 >= 41)
m.addConstr(x0**2 + x2**2 + x6**2 >= 39)
m.addConstr(x0 + x1 + x3 >= 39)
m.addConstr(x0 + x1 + x2 + x3 + x4 + x5 + x6 >= 39)
m.addConstr(2*x4**2 - 2*x5**2 >= 0)
m.addConstr(9*x0 - x3 >= 0)
m.addConstr(-2*x0 + 2*x5 >= 0)
m.addConstr(-10*x0 - 3*x3 + x5 >= 0)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("bananas: ", x0.varValue)
    print("steaks: ", x1.varValue)
    print("strawberries: ", x2.varValue)
    print("blueberry pies: ", x3.varValue)
    print("bowls of cereal: ", x4.varValue)
    print("slices of pizza: ", x5.varValue)
    print("black beans: ", x6.varValue)
else:
    print("The model is infeasible")
