
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    ringo = model.addVar(vtype=gp.GRB.INTEGER, name="ringo")
    george = model.addVar(vtype=gp.GRB.INTEGER, name="george")
    laura = model.addVar(vtype=gp.GRB.INTEGER, name="laura")
    dale = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dale")

    # Set objective function
    model.setObjective(8*ringo + 4*george + 6*laura + 9*dale, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(0.08*ringo + 2.81*laura >= 131)
    model.addConstr(2.32*george + 2.81*laura + 2.59*dale >= 111)
    model.addConstr(0.08*ringo + 2.32*george + 2.81*laura >= 111)
    model.addConstr(2.32*george + 2.81*laura + 2.59*dale >= 127)
    model.addConstr(0.08*ringo + 2.32*george + 2.81*laura >= 127)
    model.addConstr(0.08*ringo + 2.32*george + 2.81*laura + 2.59*dale >= 127)
    model.addConstr(-5*laura + 9*dale >= 0)
    model.addConstr(8*ringo - 5*laura >= 0)
    model.addConstr(0.08*ringo + 2.59*dale <= 262)
    model.addConstr(2.81*laura + 2.59*dale <= 431)
    model.addConstr(0.08*ringo + 2.32*george + 2.59*dale <= 245)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
