
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
    x2 = model.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # hours worked by George
    x3 = model.addVar(name='x3', vtype=gurobi.GRB.INTEGER)  # hours worked by Laura
    x4 = model.addVar(name='x4')  # hours worked by Dale

    # Define the objective function
    model.setObjective(8 * x1 + 4 * x2 + 6 * x3 + 9 * x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(0.08 * x1 <= 548)
    model.addConstr(2.32 * x2 <= 548)
    model.addConstr(2.81 * x3 <= 548)
    model.addConstr(2.59 * x4 <= 548)
    model.addConstr(0.08 * x1 + 2.81 * x3 >= 131)
    model.addConstr(2.32 * x2 + 2.81 * x3 + 2.59 * x4 >= 111)
    model.addConstr(0.08 * x1 + 2.32 * x2 + 2.81 * x3 >= 111)
    model.addConstr(2.32 * x2 + 2.81 * x3 + 2.59 * x4 >= 127)
    model.addConstr(0.08 * x1 + 2.32 * x2 + 2.81 * x3 >= 127)
    model.addConstr(0.08 * x1 + 2.32 * x2 + 2.81 * x3 + 2.59 * x4 >= 127)
    model.addConstr(-5 * x3 + 9 * x4 >= 0)
    model.addConstr(8 * x1 - 5 * x3 >= 0)
    model.addConstr(0.08 * x1 + 2.59 * x4 <= 262)
    model.addConstr(2.81 * x3 + 2.59 * x4 <= 431)
    model.addConstr(0.08 * x1 + 2.32 * x2 + 2.59 * x4 <= 245)

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
        print('x3: ', x3.varValue)
        print('x4: ', x4.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
