
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", lb=-float('inf'), ub=float('inf'))  # hours worked by Ringo
x2 = m.addVar(name="x2", lb=-float('inf'), ub=float('inf'))  # hours worked by Bobby
x3 = m.addVar(name="x3", lb=0, ub=float('inf'), integrality=1)  # hours worked by Dale
x4 = m.addVar(name="x4", lb=0, ub=float('inf'), integrality=1)  # hours worked by Laura

# Define the objective function
m.setObjective(9 * x1**2 + 6 * x1 * x2 + 5 * x1 * x4 + 4 * x2 * x4 + 9 * x3 * x4 + x3 + 8 * x4, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.38 * x1 <= 322)
m.addConstr(18.15 * x1 <= 440)
m.addConstr(6.59 * x2 <= 322)
m.addConstr(8.98 * x2 <= 440)
m.addConstr(18.38 * x3 <= 322)
m.addConstr(13.32 * x3 <= 440)
m.addConstr(1.66 * x4 <= 322)
m.addConstr(21.23 * x4 <= 440)
m.addConstr(1.38 * x1 + 1.66 * x4 >= 28)
m.addConstr(6.59 * x2 + 1.66 * x4 >= 71)
m.addConstr(18.38 * x3 + 1.66 * x4 >= 31)
m.addConstr(1.38**2 * x1**2 + 18.38**2 * x3**2 >= 42)
m.addConstr(1.38**2 * x1**2 + 18.38**2 * x3**2 + 1.66**2 * x4**2 >= 69)
m.addConstr(8.98 * x2 + 13.32 * x3 >= 79)
m.addConstr(13.32 * x3 + 21.23 * x4 >= 45)
m.addConstr(18.15 * x1 + 8.98 * x2 + 21.23 * x4 >= 102)
m.addConstr(8.98**2 * x2**2 + 13.32**2 * x3**2 + 21.23**2 * x4**2 >= 102)
m.addConstr(18.15 * x1 + 8.98 * x2 + 21.23 * x4 >= 81)
m.addConstr(8.98**2 * x2**2 + 13.32**2 * x3**2 + 21.23**2 * x4**2 >= 81)
m.addConstr(1.38 * x1 + 18.38 * x3 <= 298)
m.addConstr(6.59**2 * x2**2 + 18.38**2 * x3**2 <= 220)
m.addConstr(1.38 * x1 + 1.66 * x4 <= 169)
m.addConstr(1.38**2 * x1**2 + 6.59**2 * x2**2 <= 144)
m.addConstr(6.59 * x2 + 1.66 * x4 <= 93)
m.addConstr(18.38 * x3 + 1.66 * x4 <= 149)
m.addConstr(1.38 * x1 + 6.59 * x2 + 18.38 * x3 + 1.66 * x4 <= 149)
m.addConstr(18.15**2 * x1**2 + 21.23**2 * x4**2 <= 361)
m.addConstr(13.32 * x3 + 21.23 * x4 <= 316)
m.addConstr(18.15**2 * x1**2 + 8.98**2 * x2**2 <= 126)
m.addConstr(18.15 * x1 + 13.32 * x3 + 21.23 * x4 <= 435)
m.addConstr(18.15**2 * x1**2 + 8.98**2 * x2**2 + 21.23**2 * x4**2 <= 297)
m.addConstr(18.15 * x1 + 8.98 * x2 + 13.32 * x3 + 21.23 * x4 <= 297)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("The model is infeasible")
