
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0")  # milligrams of calcium
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1")  # milligrams of vitamin B3
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # grams of fiber
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="x3")  # milligrams of vitamin D
x4 = m.addVar(vtype=gp.GRB.INTEGER, name="x4")  # milligrams of vitamin E
x5 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x5")  # milligrams of vitamin A

# Objective function
m.setObjective(9*x0**2 + 3*x0*x1 + 7*x0*x2 + x0*x3 + 5*x1**2 + 6*x1*x2 + 6*x1*x4 + 8*x2**2 + x2*x3 + 7*x2*x4 + x2*x5 + 6*x3**2 + x3*x4 + 4*x3*x5 + 2*x4*x5 + 3*x5**2 + 5*x1 + 2*x2 + 5*x3 + 3*x4, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(28*x0 <= 435)
m.addConstr(23*x0 <= 543)
m.addConstr(8*x0 <= 580)
m.addConstr(13*x1 <= 435)
m.addConstr(16*x1 <= 543)
m.addConstr(17*x1 <= 580)
m.addConstr(22*x2 <= 435)
m.addConstr(3*x2 <= 543)
m.addConstr(18*x2 <= 580)
m.addConstr(5*x3 <= 435)
m.addConstr(27*x3 <= 543)
m.addConstr(22*x3 <= 580)
m.addConstr(20*x4 <= 435)
m.addConstr(29*x4 <= 543)
m.addConstr(28*x4 <= 580)
m.addConstr(31*x5 <= 435)
m.addConstr(11*x5 <= 543)
m.addConstr(27*x5 <= 580)
m.addConstr(28*x0 + 22*x2 >= 59)
m.addConstr(28**2*x0**2 + 13**2*x1**2 + 20**2*x4**2 >= 56)
m.addConstr(28**2*x0**2 + 22**2*x2**2 + 31**2*x5**2 >= 56)
m.addConstr(28*x0 + 13*x1 + 20*x4 >= 70)
m.addConstr(28*x0 + 22*x2 + 31*x5 >= 70)
m.addConstr(3*x2 + 11*x5 >= 31)
m.addConstr(23**2*x0**2 + 29**2*x4**2 >= 45)
m.addConstr(16*x1 + 29*x4 >= 31)
m.addConstr(16*x1 + 3*x2 >= 83)
m.addConstr(16**2*x1**2 + 31**2*x5**2 >= 50)
m.addConstr(17**2*x1**2 + 18**2*x2**2 + 22**2*x3**2 >= 48)
m.addConstr(28**2*x0**2 + 13**2*x1**2 <= 85)
m.addConstr(28**2*x0**2 + 31**2*x5**2 <= 210)
m.addConstr(22*x2 + 31*x5 <= 400)
m.addConstr(22**2*x2**2 + 22**2*x3**2 <= 158)
m.addConstr(22*x2 + 20*x4 <= 290)
m.addConstr(13*x1 + 22*x2 <= 189)
m.addConstr(28*x0 + 20*x4 <= 350)
m.addConstr(28*x0 + 5*x3 <= 126)
m.addConstr(20*x4 + 31*x5 <= 115)
m.addConstr(13*x1 + 5*x3 <= 330)
m.addConstr(28*x0 + 13*x1 + 22*x2 + 5*x3 + 20*x4 + 31*x5 <= 330)
m.addConstr(16**2*x1**2 + 31**2*x5**2 <= 244)
m.addConstr(23**2*x0**2 + 16**2*x1**2 + 31**2*x5**2 <= 214)
m.addConstr(3*x2 + 27*x3 + 11*x5 <= 354)
m.addConstr(23*x0 + 16*x1 + 3*x2 + 27*x3 + 29*x4 + 11*x5 <= 354)
m.addConstr(8*x0 + 18*x2 <= 550)
m.addConstr(27*x3 + 29*x4 <= 404)
m.addConstr(8**2*x0**2 + 27**2*x5**2 <= 297)
m.addConstr(29*x4 + 27*x5 <= 188)
m.addConstr(18**2*x2**2 + 22**2*x3**2 <= 394)
m.addConstr(17**2*x1**2 + 22**2*x3**2 <= 410)
m.addConstr(8**2*x0**2 + 13**2*x1**2 <= 104)
m.addConstr(8*x0 + 13*x1 + 5*x3 <= 192)
m.addConstr(8*x0 + 13*x1 + 27*x5 <= 567)
m.addConstr(13*x1 + 18*x2 + 27*x5 <= 193)
m.addConstr(8**2*x0**2 + 13**2*x1**2 + 20**2*x4**2 <= 462)
m.addConstr(13*x1 + 18*x2 + 29*x4 <= 528)
m.addConstr(8*x0 + 18*x2 + 29*x4 <= 574)
m.addConstr(8*x0 + 29*x4 + 27*x5 <= 577)
m.addConstr(13*x1 + 29*x4 + 27*x5 <= 530)
m.addConstr(8*x0 + 13*x1 + 18*x2 + 5*x3 + 29*x4 + 27*x5 <= 530)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
else:
    print("No solution found")
