
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")


# Set objective function
m.setObjective(8*x0 + 7*x1 + 8*x2 + 4*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 18*x2 >= 60)
m.addConstr(18*x2 + 19*x3 >= 70)
m.addConstr(8*x0 + 18*x2 >= 40)
m.addConstr(8*x0 + 19*x3 >= 52)
m.addConstr(8*x0 + 18*x2 + 19*x3 >= 47)
m.addConstr(8*x0 + 2*x1 + 18*x2 >= 47)
m.addConstr(8*x0 + 18*x2 + 19*x3 >= 67)
m.addConstr(8*x0 + 2*x1 + 18*x2 >= 67)
m.addConstr(10*x0 + 6*x3 >= 96)
m.addConstr(10*x0 + 17*x2 >= 90)
m.addConstr(21*x1 + 6*x3 >= 61)
m.addConstr(10*x0 + 21*x1 >= 121)
m.addConstr(10*x0 + 21*x1 + 6*x3 >= 109)
m.addConstr(17*x1 + 18*x3 >= 48)
m.addConstr(3*x2 + 18*x3 >= 43)
m.addConstr(10*x0 + 18*x3 >= 55)
m.addConstr(17*x1 + 3*x2 >= 54)
m.addConstr(17*x1 + 3*x2 + 18*x3 >= 58)
m.addConstr(8*x0 + 19*x3 <= 262)
m.addConstr(8*x0 + 18*x2 <= 190)
m.addConstr(18*x2 + 19*x3 <= 193)
m.addConstr(8*x0 + 2*x1 + 18*x2 + 19*x3 <= 193)
m.addConstr(10*x0 + 17*x2 <= 499)
m.addConstr(17*x2 + 6*x3 <= 233)
m.addConstr(21*x1 + 17*x2 <= 256)
m.addConstr(21*x1 + 17*x2 + 6*x3 <= 153)
m.addConstr(10*x0 + 21*x1 + 17*x2 <= 256)
m.addConstr(10*x0 + 21*x1 + 6*x3 <= 369)
m.addConstr(10*x0 + 17*x2 + 6*x3 <= 376)
m.addConstr(10*x0 + 21*x1 + 17*x2 + 6*x3 <= 376)
m.addConstr(17*x1 + 18*x3 <= 68)
m.addConstr(10*x0 + 18*x3 <= 166)
m.addConstr(3*x2 + 18*x3 <= 231)
m.addConstr(17*x1 + 3*x2 <= 199)
m.addConstr(10*x0 + 17*x1 + 3*x2 + 18*x3 <= 199)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

