
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize Labor Cost")

# Create variables
bill_hours = model.addVar(vtype=gp.GRB.INTEGER, name="bill_hours")
jean_hours = model.addVar(vtype=gp.GRB.INTEGER, name="jean_hours")
paul_hours = model.addVar(vtype=gp.GRB.INTEGER, name="paul_hours")


# Set objective function
model.setObjective(2 * bill_hours + 9 * jean_hours + 4 * paul_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * jean_hours + 4 * paul_hours >= 13, "c1")
model.addConstr(8 * bill_hours + 4 * paul_hours >= 11, "c2")
model.addConstr(8 * bill_hours + 7 * jean_hours + 4 * paul_hours >= 11, "c3")
model.addConstr(jean_hours + 3 * paul_hours >= 6, "c4")
model.addConstr(bill_hours + 3 * paul_hours >= 12, "c5")
model.addConstr(bill_hours + jean_hours + 3 * paul_hours >= 12, "c6")
model.addConstr(-3 * bill_hours + 8 * jean_hours >= 0, "c7")
model.addConstr(-2 * bill_hours + 6 * paul_hours >= 0, "c8")
model.addConstr(7 * jean_hours + 4 * paul_hours <= 25, "c9")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: {model.objVal}")
    print(f"Bill's hours: {bill_hours.x}")
    print(f"Jean's hours: {jean_hours.x}")
    print(f"Paul's hours: {paul_hours.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

