
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Bill
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Jean
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Paul

    # Define the objective function
    model.setObjective(2 * x0 + 9 * x1 + 4 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7 * x1 + 4 * x2 >= 13)
    model.addConstr(8 * x0 + 4 * x2 >= 11)
    model.addConstr(8 * x0 + 7 * x1 + 4 * x2 >= 11)
    model.addConstr(x1 + 3 * x2 >= 6)
    model.addConstr(x0 + 3 * x2 >= 12)
    model.addConstr(x0 + x1 + 3 * x2 >= 12)
    model.addConstr(-3 * x0 + 8 * x1 >= 0)
    model.addConstr(-2 * x0 + 6 * x2 >= 0)
    model.addConstr(7 * x1 + 4 * x2 <= 25)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bill: {x0.varValue}")
        print(f"Hours worked by Jean: {x1.varValue}")
        print(f"Hours worked by Paul: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
