
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="yellow_highlighters")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="blue_pens")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="mechanical_pencils")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="wooden_pencils")


# Set objective function
m.setObjective(4*x0 + 2*x1 + 6*x2 + 3*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x0 + 2*x1 >= 9)
m.addConstr(6*x0 + 9*x3 >= 11)
m.addConstr(6*x0 + 2*x1 + 4*x2 + 9*x3 >= 11)
m.addConstr(2*x0 + 8*x3 >= 26)
m.addConstr(3*x1 + 4*x2 >= 11)
m.addConstr(2*x0 + 3*x1 + 8*x3 >= 17)
m.addConstr(3*x1 + 4*x2 + 8*x3 >= 17)
m.addConstr(2*x0 + 4*x2 + 8*x3 >= 17)
m.addConstr(2*x0 + 3*x1 + 8*x3 >= 13)
m.addConstr(3*x1 + 4*x2 + 8*x3 >= 13)
m.addConstr(2*x0 + 4*x2 + 8*x3 >= 13)
m.addConstr(2*x0 + 3*x1 + 8*x3 >= 17)
m.addConstr(3*x1 + 4*x2 + 8*x3 >= 17)
m.addConstr(2*x0 + 4*x2 + 8*x3 >= 17)
m.addConstr(2*x0 + 3*x1 + 4*x2 + 8*x3 >= 17)
m.addConstr(3*x2 + 3*x3 >= 10)
m.addConstr(2*x1 + 3*x2 >= 12)
m.addConstr(2*x0 + 2*x1 >= 22)
m.addConstr(2*x0 + 3*x2 >= 13)
m.addConstr(2*x0 + 2*x1 + 3*x2 + 3*x3 >= 13)
m.addConstr(5*x1 + 2*x2 >= 16)
m.addConstr(11*x0 + 5*x3 >= 11)
m.addConstr(5*x1 + 5*x3 >= 13)
m.addConstr(11*x0 + 2*x2 >= 15)
m.addConstr(11*x0 + 5*x1 + 2*x2 + 5*x3 >= 15)
m.addConstr(x1 + 8*x2 >= 8)
m.addConstr(3*x0 + x1 >= 16)
m.addConstr(3*x0 + 8*x2 >= 15)
m.addConstr(x1 + x3 >= 20)
m.addConstr(3*x0 + x1 + 8*x2 + x3 >= 20)
m.addConstr(-7*x0 + 4*x3 >= 0)
m.addConstr(2*x1 + 3*x2 <= 63)
m.addConstr(2*x0 + 3*x2 <= 91)
m.addConstr(2*x0 + 3*x3 <= 78)
m.addConstr(2*x0 + 3*x2 + 3*x3 <= 81)
m.addConstr(2*x0 + 2*x1 + 3*x2 <= 89)
m.addConstr(2*x0 + 2*x1 + 3*x3 <= 79)
m.addConstr(2*x2 + 5*x3 <= 85)
m.addConstr(5*x1 + 5*x3 <= 62)
m.addConstr(5*x1 + 2*x2 <= 64)
m.addConstr(11*x0 + 5*x3 <= 82)
m.addConstr(11*x0 + 5*x1 + 2*x2 <= 52)
m.addConstr(11*x0 + 5*x1 + 5*x3 <= 73)
m.addConstr(x1 + 8*x2 <= 72)
m.addConstr(3*x0 + x3 <= 45)
m.addConstr(3*x0 + 8*x2 <= 61)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

