
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="yellow_highlighters", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="blue_pens", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="mechanical_pencils", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="wooden_pencils", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(4 * x0 + 2 * x1 + 6 * x2 + 3 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * x0 + 2 * x1 >= 9)
m.addConstr(6 * x0 + 9 * x3 >= 11)
m.addConstr(6 * x0 + 2 * x1 + 4 * x2 + 9 * x3 >= 11)
m.addConstr(2 * x0 + 8 * x3 >= 26)
m.addConstr(3 * x1 + 4 * x2 >= 11)
m.addConstr(2 * x0 + 3 * x1 + 8 * x3 >= 17)
m.addConstr(3 * x1 + 4 * x2 + 8 * x3 >= 17)
m.addConstr(2 * x0 + 4 * x2 + 8 * x3 >= 17)
m.addConstr(2 * x0 + 3 * x1 + 8 * x3 >= 13)
m.addConstr(3 * x1 + 4 * x2 + 8 * x3 >= 13)
m.addConstr(2 * x0 + 4 * x2 + 8 * x3 >= 13)
m.addConstr(2 * x0 + 3 * x1 + 8 * x3 >= 17)
m.addConstr(3 * x1 + 4 * x2 + 8 * x3 >= 17)
m.addConstr(2 * x0 + 4 * x2 + 8 * x3 >= 17)
m.addConstr(2 * x0 + 3 * x1 + 4 * x2 + 8 * x3 >= 17)
m.addConstr(2 * x2 + 3 * x3 >= 10)
m.addConstr(2 * x1 + 3 * x2 >= 12)
m.addConstr(2 * x0 + 2 * x1 >= 22)
m.addConstr(2 * x0 + 3 * x2 >= 13)
m.addConstr(2 * x0 + 2 * x1 + 3 * x2 + 3 * x3 >= 13)
m.addConstr(5 * x1 + 2 * x2 >= 16)
m.addConstr(11 * x0 + 5 * x3 >= 11)
m.addConstr(5 * x1 + 5 * x3 >= 13)
m.addConstr(11 * x0 + 2 * x2 >= 15)
m.addConstr(11 * x0 + 5 * x1 + 2 * x2 + 5 * x3 >= 15)
m.addConstr(x1 + 8 * x2 >= 8)
m.addConstr(3 * x0 + x1 >= 16)
m.addConstr(3 * x0 + 8 * x2 >= 15)
m.addConstr(x1 + x3 >= 20)
m.addConstr(3 * x0 + x1 + 8 * x2 + x3 >= 20)
m.addConstr(-7 * x0 + 4 * x3 >= 0)
m.addConstr(2 * x1 + 3 * x2 <= 63)
m.addConstr(2 * x0 + 3 * x2 <= 91)
m.addConstr(2 * x0 + 3 * x3 <= 78)
m.addConstr(2 * x0 + 3 * x2 + 3 * x3 <= 81)
m.addConstr(2 * x0 + 2 * x1 + 3 * x2 <= 89)
m.addConstr(2 * x0 + 2 * x1 + 3 * x3 <= 79)
m.addConstr(2 * x2 + 5 * x3 <= 85)
m.addConstr(5 * x1 + 5 * x3 <= 62)
m.addConstr(5 * x1 + 2 * x2 <= 64)
m.addConstr(11 * x0 + 5 * x3 <= 82)
m.addConstr(11 * x0 + 5 * x1 + 2 * x2 <= 52)
m.addConstr(11 * x0 + 5 * x1 + 5 * x3 <= 73)
m.addConstr(x1 + 8 * x2 <= 72)
m.addConstr(3 * x0 + x3 <= 45)
m.addConstr(3 * x0 + 8 * x2 <= 61)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Yellow Highlighters: ", x0.varValue)
    print("Blue Pens: ", x1.varValue)
    print("Mechanical Pencils: ", x2.varValue)
    print("Wooden Pencils: ", x3.varValue)
else:
    print("The model is infeasible")
