
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("Military Deployment")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="reconnaissance_troops")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="military_intelligence_companies")


    # Set objective function
    m.setObjective(1.57 * x0 + 9.68 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12 * x0 + 2 * x1 >= 48, "min_deployment_weight")
    m.addConstr(-8 * x0 + 9 * x1 >= 0, "troop_ratio")
    m.addConstr(12 * x0 + 2 * x1 <= 138, "max_deployment_weight")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"  Recon troops: {x0.x}")
        print(f"  Intel companies: {x1.x}")
        print(f"  Objective value: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
