
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x2 = m.addVar(vtype=GRB.INTEGER, name="military_intelligence_companies")

# Set the objective function
m.setObjective(1.57*x1 + 9.68*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + 2*x2 >= 48, "total_weight_min")
m.addConstr(-8*x1 + 9*x2 >= 0, "weight_ratio")
m.addConstr(12*x1 + 2*x2 <= 138, "total_weight_max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Reconnaissance troops: {x1.x}")
    print(f"Military intelligence companies: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
