
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="reconnaissance_troops", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="military_intelligence_companies", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(1.57 * x1 + 9.68 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12 * x1 + 2 * x2 >= 48, name="deployment_weight_min")
    model.addConstr(-8 * x1 + 9 * x2 >= 0, name="troops_vs_companies")
    model.addConstr(12 * x1 + 2 * x2 <= 138, name="deployment_weight_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Reconnaissance troops: {x1.varValue}")
        print(f"Military intelligence companies: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
