
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    patches_per_day = m.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")
    system_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")
    pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
    security_engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")

    # Set objective function
    m.setObjective(9 * patches_per_day + 9 * system_administrators + 4 * pen_testers + 8 * security_engineers, gp.GRB.MAXIMIZE)

    # Add constraints
    resources = {
        'r0': {'upper_bound': 133, 'x0': 2, 'x1': 3, 'x2': 7, 'x3': 8},
        'r1': {'upper_bound': 134, 'x0': 5, 'x1': 5, 'x2': 9, 'x3': 4},
        'r2': {'upper_bound': 60, 'x0': 5, 'x1': 5, 'x2': 11, 'x3': 9},
        'r3': {'upper_bound': 166, 'x0': 5, 'x1': 5, 'x2': 1, 'x3': 2}
    }
    
    for r, data in resources.items():
        m.addConstr(data['x0'] * patches_per_day + data['x1'] * system_administrators + data['x2'] * pen_testers + data['x3'] * security_engineers <= data['upper_bound'], f"{r}_upper_bound")


    constraints = [
         (3*system_administrators + 7*pen_testers >= 26), (3*system_administrators + 8*security_engineers >= 15), (2*patches_per_day + 8*security_engineers >= 11), (2*patches_per_day + 3*system_administrators >= 14), (3*system_administrators + 7*pen_testers + 8*security_engineers >= 23), (2*patches_per_day + 3*system_administrators + 7*pen_testers >= 16), (3*system_administrators + 7*pen_testers + 8*security_engineers >= 16), (5*patches_per_day + 9*pen_testers >= 22), (5*system_administrators + 9*pen_testers >= 25), (5*patches_per_day + 5*system_administrators >= 26), (5*system_administrators + 4*security_engineers >= 19), (5*patches_per_day + 4*security_engineers >= 24), (5*patches_per_day + 5*system_administrators + 9*pen_testers >= 29), (5*patches_per_day + 9*pen_testers + 4*security_engineers >= 29), (5*patches_per_day + 5*system_administrators + 9*pen_testers >= 17), (5*patches_per_day + 9*pen_testers + 4*security_engineers >= 17), (5*patches_per_day + 9*security_engineers >= 11), (5*system_administrators + 11*pen_testers >= 9), (5*patches_per_day + 5*system_administrators + 1*pen_testers >= 39), (5*system_administrators + 1*pen_testers + 2*security_engineers >= 39), (5*patches_per_day + 5*system_administrators + 1*pen_testers >= 33), (5*system_administrators + 1*pen_testers + 2*security_engineers >= 33), (2*patches_per_day + 8*security_engineers <= 125), (2*patches_per_day + 3*system_administrators + 7*pen_testers + 8*security_engineers <= 125), (5*patches_per_day + 9*pen_testers <= 76), (9*pen_testers + 4*security_engineers <= 40), (5*patches_per_day + 4*security_engineers <= 65), (5*patches_per_day + 5*system_administrators <= 52), (5*system_administrators + 4*security_engineers <= 106), (5*system_administrators + 9*pen_testers + 4*security_engineers <= 111), (5*patches_per_day + 5*system_administrators + 9*pen_testers + 4*security_engineers <= 111), (5*patches_per_day + 11*pen_testers <= 39), (5*patches_per_day + 9*security_engineers <= 36), (5*patches_per_day + 5*system_administrators + 9*security_engineers <= 18), (5*system_administrators + 11*pen_testers + 9*security_engineers <= 21), (5*patches_per_day + 5*system_administrators + 11*pen_testers + 9*security_engineers <= 21), (5*patches_per_day + 5*system_administrators <= 115), (1*pen_testers + 2*security_engineers <= 122), (5*patches_per_day + 1*pen_testers <= 164), (5*system_administrators + 2*security_engineers <= 127), (5*system_administrators + 1*pen_testers <= 88), (5*patches_per_day + 5*system_administrators + 2*security_engineers <= 106), (5*patches_per_day + 1*pen_testers + 2*security_engineers <= 61), (5*patches_per_day + 5*system_administrators + 1*pen_testers + 2*security_engineers <= 61)]

    for constraint in constraints:
        m.addConstr(constraint)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
